/*
 * QrfeSL900aTag.h
 *
 *  Created on: 27.09.2013
 *      Author: stefan.detter
 */

#ifndef QRFESL900ATAG_H_
#define QRFESL900ATAG_H_

#include "../QrfeGen2Tag.h"
#include "../../QrfeGen2AdvancedManipulatorInterface.h"

class QrfeSL900aTag : public QrfeGen2Tag
{
public:
    QrfeSL900aTag(QString tagId, QrfeGen2AdvancedManipulatorInterface* reader, QObject* parent = 0);
	virtual ~QrfeSL900aTag();

	QrfeGlobal::TMIResult setPassword ()							{return QrfeGlobal::TMI_NA;}
	QrfeGlobal::TMIResult setLogMode ()								{return QrfeGlobal::TMI_NA;}
	QrfeGlobal::TMIResult setLogLimits()							{return QrfeGlobal::TMI_NA;}
	QrfeGlobal::TMIResult getMeasurementSetup()						{return QrfeGlobal::TMI_NA;}
	QrfeGlobal::TMIResult setSFEParameters()						{return QrfeGlobal::TMI_NA;}
	QrfeGlobal::TMIResult setCalibrationData()						{return QrfeGlobal::TMI_NA;}
	QrfeGlobal::TMIResult endLog()									{return QrfeGlobal::TMI_NA;}
	QrfeGlobal::TMIResult startLog()								{return QrfeGlobal::TMI_NA;}
	QrfeGlobal::TMIResult getLogState()								{return QrfeGlobal::TMI_NA;}
	QrfeGlobal::TMIResult getCalibrationData()						{return QrfeGlobal::TMI_NA;}
	QrfeGlobal::TMIResult getBatteryLevel()							{return QrfeGlobal::TMI_NA;}
	QrfeGlobal::TMIResult setShelfLife()							{return QrfeGlobal::TMI_NA;}
	QrfeGlobal::TMIResult initialize()								{return QrfeGlobal::TMI_NA;}

	typedef enum{
		TEMPERATURE_SENSOR = 0,
		EXTERNAL_SENSOR_1 = 1,
		EXTERNAL_SENSOR_2 = 2,
		BATTERY_VOLTAGE = 3,
	} SENSOR_TYPE;

	QrfeGlobal::TMIResult getSensorValue( const QByteArray& passwd, SENSOR_TYPE sensor, bool& adError, uchar& rangeLimit, ushort& sensorValue );
	QrfeGlobal::TMIResult getSensorValue( const QByteArray& handle, const QByteArray& passwd, SENSOR_TYPE sensor, bool& adError, uchar& rangeLimit, ushort& sensorValue );

	QrfeGlobal::TMIResult openArea()								{return QrfeGlobal::TMI_NA;}
	QrfeGlobal::TMIResult accessFIFO()								{return QrfeGlobal::TMI_NA;}
};

#endif /* QRFESL900ATAG_H_ */
